import os
import tkinter as tk
from PIL import Image, ImageTk

from modules import mitglieder, kasse, staff, einstellungen, mengen

BASE_DIR = os.path.dirname(os.path.abspath(__file__))

class MainWindow(tk.Tk):
    def __init__(self):
        super().__init__()
        self.title("CSC Vereinsverwaltung 1.0 by Robert Schilke")
        self.geometry("1020x700")
        self.configure(bg='#f6fff2')

        # Header
        header_label = tk.Label(self, text="CSC VereinsApp", font=("Segoe UI", 32, "bold"), bg='#f6fff2', fg="#7ac66c")
        header_label.pack(pady=32)

        # Menü-Frame für Buttons
        menu_frame = tk.Frame(self, bg='#f6fff2')
        menu_frame.pack(pady=24)

        # Funktion für Icons
        def get_icon(name):
            icon_path = os.path.join(BASE_DIR, "static/icons", f"{name}.png")
            if os.path.exists(icon_path):
                img = Image.open(icon_path).resize((48,48))
                return ImageTk.PhotoImage(img)
            return None

        # Buttons für alle Module
        buttons = [
            ("Mitglieder", mitglieder.open, "member"),
            ("Kasse", kasse.open, "kasse"),
            ("Mengen/Chargen", mengen.open, "cannabis"),
            ("Staff", staff.open, "staff"),
            ("Einstellungen", einstellungen.open, "settings"),
        ]
        self._icons = []
        for idx, (label, cmd, iconname) in enumerate(buttons):
            icon = get_icon(iconname)
            self._icons.append(icon)
            btn = tk.Button(
                menu_frame, text=label, image=icon, compound="top",
                command=cmd,
                font=("Segoe UI", 11), bg="#e4fbe4", fg="#227233",
                relief="raised", bd=2, cursor="hand2", activebackground="#c8edc2"
            )
            btn.grid(row=0, column=idx, padx=20, pady=10, ipadx=6, ipady=8)

        # Footer
        tk.Label(self, text="© 2025 Dein CSC Club", bg='#f6fff2', fg='#7ac66c', font=("Segoe UI", 10)).pack(side="bottom", pady=15)

if __name__ == "__main__":
    app = MainWindow()
    app.mainloop()
