import tkinter as tk
from tkinter import ttk
from . import model
from . import undo

def open():
    model.init_db()
    win = tk.Toplevel()
    win.title("Audit-Log / Änderungsprotokoll")
    win.geometry("1200x500")

    columns = ("Zeit", "User", "Modul", "Aktion", "Betroffen", "Alt", "Neu", "IP")
    tree = ttk.Treeview(win, columns=columns, show="headings", height=18)
    for idx, col in enumerate(columns):
        tree.heading(col, text=col)
        tree.column(col, width=120 if idx != 5 and idx != 6 else 220)
    tree.pack(pady=8, padx=8, fill="both", expand=True)

    def refresh():
        tree.delete(*tree.get_children())
        for row in model.get_logs():
            tree.insert("", "end", values=row)
    refresh()

    tk.Button(win, text="Schließen", command=win.destroy).pack(pady=10)
    
def undo_selected():
    sel = tree.selection()
    if not sel:
        return
    log_id = tree.item(sel[0])["values"][0]
    ok, msg = undo.undo_change(log_id)
    if ok:
        messagebox.showinfo("Undo", msg)
    else:
        messagebox.showerror("Fehler", msg)

tk.Button(win, text="Ausgewählte Änderung rückgängig machen", command=undo_selected).pack(pady=4)