import sqlite3
import os

DB_PATH = os.path.join(os.path.dirname(os.path.dirname(os.path.dirname(__file__))), "db", "verein.db")

def init_db():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            CREATE TABLE IF NOT EXISTS audit_log (
                log_id INTEGER PRIMARY KEY AUTOINCREMENT,
                timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
                user_id INTEGER,
                modul TEXT,
                action TEXT,
                affected_id INTEGER,
                old_value TEXT,
                new_value TEXT,
                ip_address TEXT
            );
        """)
        conn.commit()

def add_log(user_id, modul, action, affected_id, old_value, new_value, ip_address=""):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            INSERT INTO audit_log (user_id, modul, action, affected_id, old_value, new_value, ip_address)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        """, (user_id, modul, action, affected_id, old_value, new_value, ip_address))
        conn.commit()

def get_logs(limit=100):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            SELECT timestamp, user_id, modul, action, affected_id, old_value, new_value, ip_address
            FROM audit_log ORDER BY timestamp DESC LIMIT ?
        """, (limit,))
        return c.fetchall()