import sqlite3
import os
import json

DB_PATH = os.path.join(os.path.dirname(os.path.dirname(os.path.dirname(__file__))), "db", "verein.db")

def undo_change(log_id):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        # Auditlog holen
        c.execute("SELECT modul, affected_id, old_value FROM audit_log WHERE log_id = ?", (log_id,))
        row = c.fetchone()
        if not row:
            return False, "Log-Eintrag nicht gefunden"
        modul, affected_id, old_value = row
        # Aktuell nur für Mitglieder
        if modul == "Mitglieder":
            data = json.loads(old_value)
            # Beispiel: alte Daten zurückschreiben (hier nur Name, Vorname als Demo)
            c.execute("""
                UPDATE mitglieder SET
                    vorname = ?,
                    name = ?,
                    geburtsdatum = ?,
                    adresse = ?,
                    eintrittsdatum = ?,
                    status = ?,
                    mitgliedsnummer = ?,
                    barcode_id = ?,
                    nfc_uid = ?,
                    email = ?,
                    telefon = ?
                WHERE mitglied_id = ?
            """, (data['vorname'], data['name'], data['geburtsdatum'], data['adresse'], data['eintrittsdatum'], data['status'], data['mitgliedsnummer'], data['barcode_id'], data['nfc_uid'], data['email'], data['telefon'], affected_id))
            conn.commit()
            return True, "Änderung zurückgesetzt!"
        else:
            return False, "Modul wird noch nicht unterstützt"