import tkinter as tk
from tkinter import messagebox
from . import model

def open():
    model.init_db()
    win = tk.Toplevel()
    win.title("Vereinsdaten/Einstellungen")
    win.geometry("400x340")

    fields = [
        ("Vereinsname", "name"),
        ("Vereins-ID", "id"),
        ("Adresse", "adresse"),
        ("E-Mail", "email"),
        ("Bankverbindung", "bank"),
    ]
    entries = {}
    for idx, (label, key) in enumerate(fields):
        tk.Label(win, text=label + ":", anchor="w", width=18).grid(row=idx, column=0, padx=12, pady=8, sticky="w")
        entry = tk.Entry(win, width=32)
        entry.grid(row=idx, column=1, pady=8, padx=12)
        entry.insert(0, model.get_setting(key))
        entries[key] = entry

    def save():
        for label, key in fields:
            val = entries[key].get().strip()
            model.set_setting(key, val)
        messagebox.showinfo("Gespeichert", "Vereinsdaten wurden gespeichert.")

    tk.Button(win, text="Speichern", command=save).grid(row=len(fields), column=0, pady=20, padx=12)
    tk.Button(win, text="Schließen", command=win.destroy).grid(row=len(fields), column=1, pady=20, padx=12)