import sqlite3
import os

DB_PATH = os.path.join(
    os.path.dirname(os.path.dirname(os.path.dirname(__file__))),
    "db",
    "verein.db"
)

def init_db():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            CREATE TABLE IF NOT EXISTS verein_settings (
                key TEXT PRIMARY KEY,
                value TEXT
            );
        """)
        # Standardwerte setzen (wenn leer)
        for k, v in [
            ("name", ""),
            ("id", ""),
            ("adresse", ""),
            ("email", ""),
            ("bank", ""),
            ("abgabe_limit", "25"),  # NEU: Standardlimit für Abgaben (g/Monat)
        ]:
            c.execute("INSERT OR IGNORE INTO verein_settings (key, value) VALUES (?, ?)", (k, v))
        conn.commit()

def get_setting(key):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("SELECT value FROM verein_settings WHERE key = ?", (key,))
        row = c.fetchone()
        return row[0] if row else ""

def set_setting(key, value):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute(
            "INSERT OR REPLACE INTO verein_settings (key, value) VALUES (?, ?)",
            (key, value)
        )
        conn.commit()

# Speziell für das Abgabe-Limit:
def get_limit():
    """Hole das Standard-Abgabemengen-Limit in Gramm/Monat."""
    try:
        return float(get_setting("abgabe_limit") or 25.0)
    except ValueError:
        return 25.0

def set_limit(val):
    """Setze das Standard-Abgabemengen-Limit."""
    set_setting("abgabe_limit", str(val))