import tkinter as tk
from tkinter import ttk, messagebox
from . import model

def open():
    model.init_db()
    win = tk.Toplevel()
    win.title("Kassenbuch")
    win.geometry("850x500")

    # Liste
    columns = ("Datum", "Art", "Kategorie", "Betrag", "Zweck", "Buchende Person")
    tree = ttk.Treeview(win, columns=columns, show="headings", height=15)
    for col in columns:
        tree.heading(col, text=col)
        tree.column(col, width=130)
    tree.pack(pady=12, padx=12, fill="both", expand=True)

    def refresh():
        tree.delete(*tree.get_children())
        for row in model.get_alle():
            tree.insert("", "end", values=row)
    refresh()

    # Neue Buchung
    def open_add():
        dlg = tk.Toplevel(win)
        dlg.title("Neue Buchung")
        dlg.geometry("420x380")
        fields = [
            ("Datum (JJJJ-MM-TT)", "datum"),
            ("Art", "art"),             # Einnahme/Ausgabe
            ("Kategorie", "kategorie"), # Freitext oder Dropdown
            ("Betrag", "betrag"),
            ("Zweck", "zweck"),
            ("Buchende Person", "buchende_person"),
        ]
        entries = {}
        for idx, (label, key) in enumerate(fields):
            tk.Label(dlg, text=label+":", anchor="w").grid(row=idx, column=0, sticky="w", padx=8, pady=4)
            if key == "art":
                var = tk.StringVar(value="Ausgabe")
                entry = ttk.Combobox(dlg, textvariable=var, values=["Einnahme", "Ausgabe"], width=24)
            else:
                entry = tk.Entry(dlg, width=26)
            entry.grid(row=idx, column=1, pady=4)
            entries[key] = entry

        def save():
            data = {k: v.get().strip() for k, v in entries.items()}
            if not data["datum"] or not data["betrag"] or not data["kategorie"]:
                messagebox.showerror("Fehler", "Datum, Betrag und Kategorie sind Pflichtfelder.")
                return
            try:
                data["betrag"] = float(data["betrag"])
            except Exception:
                messagebox.showerror("Fehler", "Betrag muss eine Zahl sein.")
                return
            # Platzhalter für Beleg (Datei-Upload später)
            data["beleg"] = ""
            model.add_eintrag(data)
            messagebox.showinfo("Erfolg", "Buchung gespeichert.")
            dlg.destroy()
            refresh()

        tk.Button(dlg, text="Speichern", command=save).grid(row=len(fields), column=0, pady=20)
        tk.Button(dlg, text="Abbrechen", command=dlg.destroy).grid(row=len(fields), column=1, pady=20)

    tk.Button(win, text="Neue Buchung", command=open_add).pack(pady=6)

    # Schließen
    tk.Button(win, text="Schließen", command=win.destroy).pack(pady=15)