import sqlite3
import os

DB_PATH = os.path.join(os.path.dirname(os.path.dirname(os.path.dirname(__file__))), "db", "verein.db")

def init_db():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            CREATE TABLE IF NOT EXISTS kassenbuch (
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                datum TEXT,
                art TEXT,              -- 'Einnahme' oder 'Ausgabe'
                kategorie TEXT,
                betrag REAL,
                zweck TEXT,
                beleg TEXT,
                buchende_person TEXT,
                timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
            );
        """)
        conn.commit()

def get_alle():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("SELECT datum, art, kategorie, betrag, zweck, buchende_person FROM kassenbuch ORDER BY datum DESC;")
        return c.fetchall()

def add_eintrag(data):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            INSERT INTO kassenbuch (datum, art, kategorie, betrag, zweck, beleg, buchende_person)
            VALUES (?, ?, ?, ?, ?, ?, ?);
        """, (data['datum'], data['art'], data['kategorie'], data['betrag'], data['zweck'], data['beleg'], data['buchende_person']))
        conn.commit()