import sqlite3
import os
import csv
from tkinter import filedialog, messagebox

DB_PATH = os.path.join(
    os.path.dirname(os.path.dirname(os.path.dirname(__file__))),
    "db",
    "verein.db"
)

def export_abgaben_csv():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            SELECT abgabe_id, mitglied_id, charge_id, datum, menge, bearbeiter, kommentar
            FROM abgaben
            ORDER BY datum DESC
        """)
        rows = c.fetchall()
        headers = ["Abgabe-ID", "Mitglied-ID", "Charge-ID", "Datum", "Menge (g)", "Bearbeiter", "Kommentar"]

    # Dialog zum Speichern
    file = filedialog.asksaveasfilename(
        defaultextension=".csv",
        filetypes=[("CSV-Dateien", "*.csv")],
        title="Abgaben als CSV exportieren"
    )
    if not file:
        return
    try:
        with open(file, "w", newline="", encoding="utf-8") as f:
            writer = csv.writer(f)
            writer.writerow(headers)
            for row in rows:
                writer.writerow(row)
        messagebox.showinfo("Export erfolgreich", f"CSV wurde gespeichert: {file}")
    except Exception as e:
        messagebox.showerror("Fehler", f"Fehler beim Export: {e}")

def export_chargen_csv():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            SELECT charge_id, bezeichnung, start_datum, end_datum, menge_gesamt, menge_rest, kommentar
            FROM chargen
            ORDER BY start_datum DESC
        """)
        rows = c.fetchall()
        headers = ["Charge-ID", "Bezeichnung", "Start-Datum", "End-Datum", "Gesamtmenge (g)", "Restmenge (g)", "Kommentar"]

    # Dialog zum Speichern
    file = filedialog.asksaveasfilename(
        defaultextension=".csv",
        filetypes=[("CSV-Dateien", "*.csv")],
        title="Chargen als CSV exportieren"
    )
    if not file:
        return
    try:
        with open(file, "w", newline="", encoding="utf-8") as f:
            writer = csv.writer(f)
            writer.writerow(headers)
            for row in rows:
                writer.writerow(row)
        messagebox.showinfo("Export erfolgreich", f"CSV wurde gespeichert: {file}")
    except Exception as e:
        messagebox.showerror("Fehler", f"Fehler beim Export: {e}")