import tkinter as tk
from tkinter import ttk, messagebox
from . import model
from modules.mengen import model as mengen_model
from modules.einstellungen import model as settings_model
import datetime

def open():
    model.init_db()
    win = tk.Toplevel()
    win.title("Mitgliederverwaltung")
    win.geometry("950x650")

    # --- Suchfeld ---
    search_var = tk.StringVar()

    def search():
        query = search_var.get().strip().lower()
        tree.delete(*tree.get_children())
        for row in model.get_alle_full():
            # row: (mitglied_id, vorname, name, status, mitgliedsnummer, email)
            if (query in str(row[1]).lower() or  # Vorname
                query in str(row[2]).lower() or  # Name
                query in str(row[4]).lower() or  # Mitgliedsnummer
                query in str(row[5]).lower()):   # E-Mail
                tree.insert("", "end", values=row[:-1])
        if not query:
            refresh()

    tk.Label(win, text="Suchen nach Name, Mitgliedsnummer oder E-Mail:").pack(padx=10, pady=(10,2), anchor="w")
    search_entry = tk.Entry(win, textvariable=search_var, width=32)
    search_entry.pack(padx=10, anchor="w")
    tk.Button(win, text="Suchen", command=search).pack(padx=10, pady=(0,10), anchor="w")
    search_entry.bind("<Return>", lambda e: search())

    # --- Mitgliederliste ---
    columns = ("ID", "Vorname", "Name", "Status", "Mitgliedsnummer")
    tree = ttk.Treeview(win, columns=columns, show="headings", height=18)
    for col in columns:
        tree.heading(col, text=col)
        tree.column(col, width=120)
    tree.pack(pady=6, padx=12, fill="both", expand=True)

    def refresh():
        tree.delete(*tree.get_children())
        for row in model.get_alle():
            tree.insert("", "end", values=row)
    refresh()

    # --- Neues Mitglied ---
    def open_add():
        dlg = tk.Toplevel(win)
        dlg.title("Neues Mitglied anlegen")
        dlg.geometry("410x520")
        fields = [
            ("Vorname", "vorname"),
            ("Name", "name"),
            ("Geburtsdatum", "geburtsdatum"),
            ("Adresse", "adresse"),
            ("Eintrittsdatum", "eintrittsdatum"),
            ("Status", "status"),
            ("Mitgliedsnummer", "mitgliedsnummer"),
            ("Barcode-ID", "barcode_id"),
            ("NFC-UID", "nfc_uid"),
            ("E-Mail", "email"),
            ("Telefon", "telefon"),
        ]
        entries = {}
        for idx, (label, key) in enumerate(fields):
            tk.Label(dlg, text=label+":", anchor="w").grid(row=idx, column=0, sticky="w", padx=8, pady=4)
            e = tk.Entry(dlg, width=28)
            e.grid(row=idx, column=1, pady=4)
            if key == "mitgliedsnummer":
                e.insert(0, model.next_mitgliedsnummer())
            entries[key] = e

        def save():
            data = {k: v.get().strip() for k, v in entries.items()}
            if not data["name"] or not data["vorname"]:
                messagebox.showerror("Fehler", "Vorname und Name sind Pflichtfelder.")
                return
            try:
                model.add_mitglied(data)
            except Exception as ex:
                messagebox.showerror("Fehler", f"Fehler beim Speichern: {ex}")
                return
            messagebox.showinfo("Erfolg", "Mitglied gespeichert.")
            dlg.destroy()
            refresh()

        tk.Button(dlg, text="Speichern", command=save).grid(row=len(fields), column=0, pady=20)
        tk.Button(dlg, text="Abbrechen", command=dlg.destroy).grid(row=len(fields), column=1, pady=20)

    # --- Bearbeiten ---
    def open_edit(mitglied_id):
        data = model.get_by_id(mitglied_id)
        dlg = tk.Toplevel(win)
        dlg.title("Mitglied bearbeiten")
        dlg.geometry("410x520")
        fields = [
            ("Vorname", "vorname"),
            ("Name", "name"),
            ("Geburtsdatum", "geburtsdatum"),
            ("Adresse", "adresse"),
            ("Eintrittsdatum", "eintrittsdatum"),
            ("Status", "status"),
            ("Mitgliedsnummer", "mitgliedsnummer"),
            ("Barcode-ID", "barcode_id"),
            ("NFC-UID", "nfc_uid"),
            ("E-Mail", "email"),
            ("Telefon", "telefon"),
        ]
        entries = {}
        for idx, (label, key) in enumerate(fields):
            tk.Label(dlg, text=label+":", anchor="w").grid(row=idx, column=0, sticky="w", padx=8, pady=4)
            e = tk.Entry(dlg, width=28)
            e.grid(row=idx, column=1, pady=4)
            e.insert(0, str(data.get(key, "")))
            entries[key] = e

        def save():
            updated = {k: v.get().strip() for k, v in entries.items()}
            try:
                model.update_mitglied(mitglied_id, updated)
            except Exception as ex:
                messagebox.showerror("Fehler", f"Fehler beim Speichern: {ex}")
                return
            messagebox.showinfo("Erfolg", "Mitglied gespeichert.")
            dlg.destroy()
            refresh()

        tk.Button(dlg, text="Speichern", command=save).grid(row=len(fields), column=0, pady=20)
        tk.Button(dlg, text="Abbrechen", command=dlg.destroy).grid(row=len(fields), column=1, pady=20)

    # --- Detail-/Bearbeitungsfenster ---
    def open_details(evt=None):
        sel = tree.selection()
        if not sel:
            messagebox.showinfo("Info", "Bitte ein Mitglied auswählen.")
            return
        values = tree.item(sel[0])["values"]
        mitglied_id = values[0]
        data = model.get_by_id(mitglied_id)
        monat = datetime.date.today().strftime("%Y-%m")
        abgaben = mengen_model.get_abgaben(mitglied_id, monat)
        limit = settings_model.get_limit()
        erhalten = mengen_model.get_monatsmenge_fuer_mitglied(mitglied_id, monat)
        rest = limit - erhalten

        dlg = tk.Toplevel(win)
        dlg.title(f"Mitglied {data.get('mitgliedsnummer','')}: {data.get('vorname','')} {data.get('name','')}")
        dlg.geometry("480x600")
        frame = tk.Frame(dlg)
        frame.pack(padx=10, pady=10, fill="x")

        # Stammdaten
        row = 0
        for k in ["vorname","name","geburtsdatum","adresse","eintrittsdatum","status","mitgliedsnummer","barcode_id","nfc_uid","email","telefon"]:
            tk.Label(frame, text=k.capitalize()+":", anchor="w", width=16).grid(row=row, column=0, sticky="w")
            tk.Label(frame, text=str(data.get(k,"")), anchor="w", width=30).grid(row=row, column=1, sticky="w")
            row += 1

        # Abgabenübersicht
        tk.Label(dlg, text="Abgaben (diesen Monat):", font=("Segoe UI", 10, "bold")).pack(pady=10)
        abgabe_frame = tk.Frame(dlg)
        abgabe_frame.pack()
        if abgaben:
            for a in abgaben:
                tk.Label(abgabe_frame, text=f"{a[3]} | Menge: {a[4]}g | Charge: {a[2]} | {a[6]}").pack(anchor="w")
        else:
            tk.Label(abgabe_frame, text="Keine Abgaben in diesem Monat.").pack(anchor="w")
        tk.Label(dlg, text=f"Limit: {limit}g, Erhalten: {erhalten:.2f}g, Verbleibend: {rest:.2f}g", font=("Segoe UI", 10, "bold"), fg="#237d00").pack(pady=8)

        # Buttons Bearbeiten / Löschen
        btn_frame = tk.Frame(dlg)
        btn_frame.pack(pady=16)
        tk.Button(btn_frame, text="Bearbeiten", command=lambda: [dlg.destroy(), open_edit(mitglied_id)]).pack(side="left", padx=10)
        def delete():
            if messagebox.askyesno("Mitglied löschen?", "Wirklich löschen?"):
                model.delete_mitglied(mitglied_id)
                dlg.destroy()
                refresh()
        tk.Button(btn_frame, text="Löschen", command=delete).pack(side="left", padx=10)
        tk.Button(dlg, text="Schließen", command=dlg.destroy).pack(pady=12)

    tree.bind("<Double-1>", open_details)

    # --- Buttonleiste ---
    btn_frame = tk.Frame(win)
    btn_frame.pack(pady=8)
    tk.Button(btn_frame, text="Neues Mitglied", command=open_add).pack(side="left", padx=8)
    tk.Button(btn_frame, text="Details / Bearbeiten", command=open_details).pack(side="left", padx=8)
    tk.Button(btn_frame, text="Schließen", command=win.destroy).pack(side="left", padx=8)

# --- Model-Ergänzung für Suche (nur einmal im model.py ergänzen!) ---
# Funktion gibt (mitglied_id, vorname, name, status, mitgliedsnummer, email) zurück:
# def get_alle_full():
#     with sqlite3.connect(DB_PATH) as conn:
#         c = conn.cursor()
#         c.execute("SELECT mitglied_id, vorname, name, status, mitgliedsnummer, email FROM mitglieder ORDER BY name, vorname;")
#         return c.fetchall()
