import tkinter as tk
from tkinter import ttk, messagebox, simpledialog
from . import model
import hashlib

def hashpw(pw):
    return hashlib.sha256(pw.encode("utf-8")).hexdigest()

def open():
    model.init_db()
    win = tk.Toplevel()
    win.title("Mitarbeiterverwaltung")
    win.geometry("800x480")

    # Liste
    columns = ("ID", "Benutzername", "Name", "E-Mail", "Rolle", "Status", "Letzter Login")
    tree = ttk.Treeview(win, columns=columns, show="headings", height=15)
    for col in columns:
        tree.heading(col, text=col)
        tree.column(col, width=120)
    tree.pack(pady=12, padx=12, fill="both", expand=True)

    def refresh():
        tree.delete(*tree.get_children())
        for row in model.get_alle():
            tree.insert("", "end", values=row)
    refresh()

    # Neues Staff-Konto
    def open_add():
        dlg = tk.Toplevel(win)
        dlg.title("Neuer Account")
        dlg.geometry("400x420")
        fields = [
            ("Benutzername", "username"),
            ("Name (optional)", "fullname"),
            ("E-Mail", "email"),
            ("Rolle", "role"),    # Vorstand, Kassenwart, Ausgabe, …
            ("Status", "status"),
            ("Passwort", "password"),
        ]
        entries = {}
        for idx, (label, key) in enumerate(fields):
            tk.Label(dlg, text=label+":", anchor="w").grid(row=idx, column=0, sticky="w", padx=8, pady=4)
            if key == "role":
                var = tk.StringVar(value="Vorstand")
                entry = ttk.Combobox(dlg, textvariable=var, values=["Vorstand", "Kassenwart", "Ausgabe", "Datenschutz"], width=24)
            elif key == "status":
                var = tk.StringVar(value="active")
                entry = ttk.Combobox(dlg, textvariable=var, values=["active", "suspended"], width=24)
            elif key == "password":
                entry = tk.Entry(dlg, show="*", width=26)
            else:
                entry = tk.Entry(dlg, width=26)
            entry.grid(row=idx, column=1, pady=4)
            entries[key] = entry

        def save():
            data = {k: v.get().strip() for k, v in entries.items()}
            if not data["username"] or not data["password"] or not data["role"]:
                messagebox.showerror("Fehler", "Benutzername, Passwort und Rolle sind Pflichtfelder.")
                return
            data["password_hash"] = hashpw(data["password"])
            del data["password"]
            model.add_staff(data)
            messagebox.showinfo("Erfolg", "Account gespeichert.")
            dlg.destroy()
            refresh()

        tk.Button(dlg, text="Speichern", command=save).grid(row=len(fields), column=0, pady=20)
        tk.Button(dlg, text="Abbrechen", command=dlg.destroy).grid(row=len(fields), column=1, pady=20)

    tk.Button(win, text="Neuen Account", command=open_add).pack(pady=6)

    # Sperren/Löschen Button (auf selektierte Zeile)
    def suspend_selected():
        sel = tree.selection()
        if not sel:
            messagebox.showinfo("Info", "Kein Account ausgewählt.")
            return
        staff_id = tree.item(sel[0])["values"][0]
        model.suspend_staff(staff_id)
        refresh()

    def delete_selected():
        sel = tree.selection()
        if not sel:
            messagebox.showinfo("Info", "Kein Account ausgewählt.")
            return
        staff_id = tree.item(sel[0])["values"][0]
        if messagebox.askyesno("Wirklich löschen?", "Account unwiderruflich löschen?"):
            model.delete_staff(staff_id)
            refresh()

    tk.Button(win, text="Account sperren", command=suspend_selected).pack(pady=2)
    tk.Button(win, text="Account löschen", command=delete_selected).pack(pady=2)

    # Schließen
    tk.Button(win, text="Schließen", command=win.destroy).pack(pady=15)