import sqlite3
import os

DB_PATH = os.path.join(os.path.dirname(os.path.dirname(os.path.dirname(__file__))), "db", "verein.db")

def init_db():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            CREATE TABLE IF NOT EXISTS staff_accounts (
                staff_id INTEGER PRIMARY KEY AUTOINCREMENT,
                username TEXT UNIQUE NOT NULL,
                fullname TEXT,
                email TEXT,
                role TEXT NOT NULL,
                status TEXT DEFAULT 'active', -- active, suspended, deleted
                password_hash TEXT NOT NULL,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                updated_at DATETIME,
                last_login DATETIME
            );
        """)
        conn.commit()

def get_alle():
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("SELECT staff_id, username, fullname, email, role, status, last_login FROM staff_accounts ORDER BY role, fullname;")
        return c.fetchall()

def add_staff(data):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("""
            INSERT INTO staff_accounts (username, fullname, email, role, status, password_hash)
            VALUES (?, ?, ?, ?, ?, ?);
        """, (data['username'], data['fullname'], data['email'], data['role'], data['status'], data['password_hash']))
        conn.commit()

def suspend_staff(staff_id):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("UPDATE staff_accounts SET status = 'suspended' WHERE staff_id = ?;", (staff_id,))
        conn.commit()

def delete_staff(staff_id):
    with sqlite3.connect(DB_PATH) as conn:
        c = conn.cursor()
        c.execute("UPDATE staff_accounts SET status = 'deleted' WHERE staff_id = ?;", (staff_id,))
        conn.commit()