# 🎯 QianNiao Kamera Freischalten - Schritt für Schritt

**Copyright © 2025 datenretter-pro.de**  
**Version 3.0 FINAL**

---

## 📖 Für absolute Anfänger - So einfach wie möglich!

Diese Anleitung erklärt **ALLES** Schritt für Schritt.  
Du brauchst **KEINE** Linux-Kenntnisse!

---

## ⏱️ Zeitbedarf: 10 Minuten

- ✅ 2 Minuten: Dateien kopieren
- ✅ 5 Minuten: Script ausführen  
- ✅ 2 Minuten: Kamera neu starten
- ✅ 1 Minute: Testen

---

## 🛠️ Was du brauchst:

1. ✅ Deine QianNiao Kamera (Model QN-L73PV18A0 oder ähnlich)
2. ✅ Einen Computer (Windows, Mac oder Linux)
3. ✅ Die Kamera muss im gleichen Netzwerk sein
4. ✅ Die Datei: `qianniao_unlock_final.sh`

**Das wars! Mehr brauchst du nicht!**

---

## 🚀 SCHRITT 1: Kamera-IP herausfinden

### Windows:

1. Öffne "Eingabeaufforderung" (CMD)
2. Tippe: `arp -a`
3. Suche nach deiner Kamera-IP (z.B. `192.168.1.203`)

### Mac/Linux:

1. Öffne Terminal
2. Tippe: `arp -a` oder nutze `nmap -sn 192.168.1.0/24`
3. Finde deine Kamera

### Alternative: Router-Interface

1. Öffne Router-Webseite (meist `192.168.1.1` oder `192.168.0.1`)
2. Gehe zu "Verbundene Geräte" oder "DHCP Clients"
3. Suche nach "QianNiao" oder "IPC-Camera"

**Notiere dir die IP-Adresse!** z.B. `192.168.1.203`

---

## 🚀 SCHRITT 2: Datei auf Kamera kopieren

### Option A: Mit SCP (Empfohlen)

**Windows (PowerShell oder CMD):**
```cmd
scp qianniao_unlock_final.sh root@192.168.1.203:/tmp/
```

**Mac/Linux (Terminal):**
```bash
scp qianniao_unlock_final.sh root@192.168.1.203:/tmp/
```

**Passwort:** `root`

### Option B: Mit WinSCP (Windows, einfacher!)

1. Lade WinSCP herunter: https://winscp.net/
2. Installiere und starte WinSCP
3. Neue Verbindung:
   - Protokoll: **SCP**
   - Hostname: **192.168.1.203** (deine Kamera-IP)
   - Port: **22**
   - Benutzername: **root**
   - Passwort: **root**
4. Klicke "Anmelden"
5. Ziehe `qianniao_unlock_final.sh` in das `/tmp/` Verzeichnis

### Option C: Mit SD-Karte (Falls SSH nicht geht)

1. Kopiere `qianniao_unlock_final.sh` auf SD-Karte
2. Stecke SD-Karte in Kamera
3. Fahre mit Schritt 3 fort (Script liegt dann in `/mnt/sd/`)

---

## 🚀 SCHRITT 3: Per SSH verbinden

### Windows:

**PowerShell oder CMD:**
```cmd
ssh root@192.168.1.203
```

Passwort: `root`

**Oder mit PuTTY:**
1. Lade PuTTY: https://putty.org/
2. Hostname: `192.168.1.203`
3. Port: `22`
4. Connection Type: `SSH`
5. Klicke "Open"
6. Login: `root`
7. Password: `root`

### Mac/Linux:

**Terminal:**
```bash
ssh root@192.168.1.203
```

Passwort: `root`

**Du bist jetzt auf der Kamera eingeloggt!** ✅

---

## 🚀 SCHRITT 4: Script ausführen

**Auf der Kamera-Konsole:**

```bash
cd /tmp
chmod +x qianniao_unlock_final.sh
./qianniao_unlock_final.sh
```

**Oder wenn von SD-Karte:**

```bash
chmod +x /mnt/sd/qianniao_unlock_final.sh
/mnt/sd/qianniao_unlock_final.sh
```

---

## 🎬 SCHRITT 5: Script folgen

Das Script wird dich durch **8 Schritte** führen:

### Was du sehen wirst:

```
╔════════════════════════════════════════════╗
║  QianNiao Camera - Ultimate Unlock Tool   ║
║  Version 3.0                               ║
║  Copyright (c) 2025 datenretter-pro.de    ║
╚════════════════════════════════════════════╝

⚠️  WICHTIGE WARNUNG  ⚠️

Möchtest du fortfahren? (ja/nein)
```

**Tippe:** `ja` und drücke ENTER

### Das Script macht dann:

1. ✅ System-Check
2. ✅ Info sammeln (MAC, IP, DevKey)
3. ✅ **Backup erstellen** (automatisch!)
4. ✅ Apollo Binary patchen
5. ✅ Neues Firmware-Image bauen
6. ✅ Firmware flashen (fragt nochmal nach!)
7. ✅ Cloud blocken
8. ✅ Zusammenfassung zeigen

### Wichtige Fragen im Script:

**Nach Warnung:**
```
Möchtest du fortfahren? (ja/nein)
```
→ Tippe: `ja`

**Vor dem Flashen:**
```
Fortfahren? (ja/nein)
```
→ Tippe: `ja`

**Am Ende:**
```
Kamera jetzt neustarten? (ja/nein)
```
→ Tippe: `ja`

---

## 🎉 SCHRITT 6: Fertig!

### Nach dem Neustart (ca. 1-2 Minuten warten):

Das Script zeigt dir am Ende **ALLE** wichtigen Informationen:

```
═══════════════════════════════════════════
  ZUGANGSDATEN
═══════════════════════════════════════════

Root-Zugang (SSH/Telnet):
  Username: root
  Password: root

Admin (ONVIF/RTSP):
  Username: admin
  Password: admin123456

Super-Admin:
  Username: admin
  Password: qianniaosuper

═══════════════════════════════════════════
  DIENSTE
═══════════════════════════════════════════

ONVIF:
  http://192.168.1.203:6688/onvif/device_service

RTSP Streams:
  Main:  rtsp://admin:admin123456@192.168.1.203:8554/profile0
  Sub:   rtsp://admin:admin123456@192.168.1.203:8554/profile1
```

---

## 🧪 SCHRITT 7: Testen

### Test 1: ONVIF im Browser

1. Öffne Browser
2. Gehe zu: `http://192.168.1.203:6688/onvif/device_service`
3. Du solltest XML sehen (ONVIF Device Info)

**Erfolg:** ✅ Wenn XML erscheint  
**Fehler:** ❌ Wenn "Connection refused"

### Test 2: RTSP mit VLC

1. Öffne VLC Media Player
2. Medien → Netzwerkstream öffnen
3. URL: `rtsp://admin:admin123456@192.168.1.203:8554/profile1`
4. Klicke "Abspielen"

**Erfolg:** ✅ Wenn Video erscheint  
**Fehler:** ❌ Wenn "Cannot open"

### Test 3: SSH-Zugriff

```bash
ssh root@192.168.1.203
Password: root
```

**Erfolg:** ✅ Wenn du eingeloggt bist  
**Fehler:** ❌ Wenn "Connection refused"

---

## 🏠 SCHRITT 8: Home Assistant einrichten

### In Home Assistant:

1. Gehe zu **Einstellungen** → **Geräte & Dienste**
2. Klicke **Integration hinzufügen**
3. Suche nach **ONVIF**
4. Konfiguration:
   - Host: `192.168.1.203`
   - Port: `6688`
   - Benutzername: `admin`
   - Passwort: `admin123456`
5. Klicke **Absenden**

**Fertig!** Kamera ist jetzt in Home Assistant! 🎉

---

## 🆘 HILFE - Etwas ging schief!

### Problem 1: "Connection refused" beim SSH

**Lösung:**
- Prüfe IP-Adresse: `ping 192.168.1.203`
- Prüfe ob Port 22 offen: `telnet 192.168.1.203 23`
- Nutze Telnet statt SSH: `telnet 192.168.1.203`

### Problem 2: Script findet MTD6 nicht

**Lösung:**
- Prüfe ob du wirklich auf der Kamera bist
- Prüfe: `ls -l /dev/mtd*`
- Wenn leer: Falsche Kamera oder falsches Model

### Problem 3: ONVIF geht nicht nach Neustart

**Lösung:**
```bash
# Einloggen per SSH
ssh root@192.168.1.203

# Apollo neu starten
killall apollo
/app/abin/apollo &

# Warte 10 Sekunden
sleep 10

# Teste Port
netstat -ln | grep 6688
```

### Problem 4: Kamera bootet nicht mehr

**Lösung (Backup wiederherstellen):**
```bash
# Via SSH (wenn noch möglich)
ssh root@192.168.1.203

# Backup finden
ls /tmp/backup_*/

# Wiederherstellen
dd if=/tmp/backup_XXXXXX/mtd6_original.img of=/dev/mtd6
reboot
```

**Oder via SD-Karte:**
```bash
# Backup von SD laden
dd if=/mnt/sd/backup_XXXXXX/mtd6_original.img of=/dev/mtd6
reboot
```

---

## 📞 Support & Mehr Infos

### Website:
**https://datenretter-pro.de**

### Blog-Posts:
- Teil 1: https://datenretter-pro.de/2025/04/20/qianniao-kamera/
- Teil 2: https://datenretter-pro.de/2025/07/14/qianniao-kamera-part-ii/

### Weitere Tools:
Alle Tools und Anleitungen auf der Website!

---

## ✅ Checkliste - Hast du alles?

- [ ] Kamera-IP gefunden
- [ ] Script auf Kamera kopiert
- [ ] Per SSH eingeloggt
- [ ] Script ausgeführt
- [ ] "ja" bei Warnung bestätigt
- [ ] "ja" beim Flash bestätigt
- [ ] Kamera neu gestartet
- [ ] ONVIF getestet
- [ ] RTSP getestet
- [ ] Home Assistant eingerichtet

**Wenn alle Häkchen da sind: FERTIG! 🎉**

---

## 🎯 Zusammenfassung - Das Wichtigste:

### Vorher:
- ❌ Cloud-abhängig
- ❌ V360 App nötig
- ❌ Kein ONVIF
- ❌ Kein Root-Zugriff
- ❌ Vendor Lock-in

### Nachher:
- ✅ 100% lokal
- ✅ Standard-Protokolle
- ✅ ONVIF & RTSP
- ✅ Voller Root-Zugriff
- ✅ Home Assistant ready
- ✅ Deine Kamera, deine Regeln!

---

**Copyright © 2025 datenretter-pro.de**  
**Tool Version: 3.0 FINAL**  
**Viel Erfolg! 🚀**
