# 🎯 QianNiao Kamera - Komplettes Unlock-Paket

**Copyright © 2025 datenretter-pro.de**  
**Version: 3.0 FINAL**

---

## 📦 Paket-Inhalt

Dieses Paket enthält **ALLES** was du brauchst:

### **Hauptdateien:**

1. **ultimate_mtd6.img** (5.4 MB)
   - Fertig gepatchte Firmware
   - Sofort flashbar
   - Keine weiteren Modifikationen nötig

2. **qianniao_unlock_final.sh** (23 KB)
   - Baut Firmware selbst (aus aktueller MTD6)
   - Für Leute die eigene Mods wollen
   - Vollautomatisch

3. **flash_firmware.sh** (7.4 KB)
   - Flasht vorgefertigtes Image
   - Schnelle Option
   - Einfach & sicher

4. **devkey_calculator.py**
   - Berechnet DevKey aus MAC
   - Für Advanced Users

5. **ANLEITUNG_FÜR_DUMMIES.md**
   - Schritt-für-Schritt Guide
   - Für Anfänger
   - Alles erklärt

---

## 🚀 Schnellstart - 2 Methoden

### **Methode 1: Vorgefertigte Firmware (SCHNELL - 5 Minuten)**

**Für Leute die es schnell haben wollen:**

```bash
# 1. Dateien kopieren
scp ultimate_mtd6.img flash_firmware.sh root@192.168.1.203:/tmp/

# 2. SSH zur Kamera
ssh root@192.168.1.203

# 3. Flasher starten
cd /tmp
chmod +x flash_firmware.sh
./flash_firmware.sh

# 4. Fertig! Kamera wird neu gestartet
```

**Das macht der Flasher:**
- ✅ Automatisches Backup
- ✅ MTD6 löschen
- ✅ Neue Firmware flashen
- ✅ Reboot

---

### **Methode 2: Selbst bauen (ADVANCED - 10 Minuten)**

**Für Leute die volle Kontrolle wollen:**

```bash
# 1. Unlock-Script kopieren
scp qianniao_unlock_final.sh root@192.168.1.203:/tmp/

# 2. SSH zur Kamera
ssh root@192.168.1.203

# 3. Script starten
cd /tmp
chmod +x qianniao_unlock_final.sh
./qianniao_unlock_final.sh

# 4. Script folgen (8 Schritte)
```

**Das macht das Unlock-Script:**
- ✅ System-Check
- ✅ DevKey berechnen
- ✅ Backup erstellen
- ✅ Apollo patchen
- ✅ Firmware neu bauen
- ✅ Flashen
- ✅ Cloud blocken
- ✅ Alles anzeigen

---

## 📋 Was ist in der Firmware?

### **Vorgefertigtes Image (ultimate_mtd6.img):**

✅ **Apollo Binary:** Gepatcht für ONVIF
- Offset 0x139a4: License-Check entfernt
- Offset 0x13950: License-Check entfernt

✅ **Startup Scripts:** Modifiziert
- Cloud automatisch geblockt
- Telnet automatisch gestartet
- Root-Passwort gesetzt

✅ **Auto-Unlock Script:** Eingefügt
- Läuft bei jedem Boot
- Stellt sicher dass alles aktiv bleibt

✅ **Default Config:** Optimiert
- Alle Features enabled
- ONVIF auf Port 6688
- RTSP auf Port 8554

---

## 🔑 Zugangsdaten (Nach Unlock)

### **Root-Zugang:**
```
SSH/Telnet:
  Username: root
  Password: root
```

### **ONVIF/RTSP:**
```
Standard Admin:
  Username: admin
  Password: admin123456

Super Admin:
  Username: admin
  Password: qianniaosuper
```

---

## 🌐 Services (Nach Unlock)

### **ONVIF:**
```
URL: http://<KAMERA_IP>:6688/onvif/device_service

Teste im Browser:
http://192.168.1.203:6688/onvif/device_service
```

### **RTSP Streams:**
```
Main Stream (1280x720):
  rtsp://admin:admin123456@<KAMERA_IP>:8554/profile0

Sub Stream (640x480):
  rtsp://admin:admin123456@<KAMERA_IP>:8554/profile1

High Quality:
  rtsp://admin:admin123456@<KAMERA_IP>:8554/profile100

Low Latency:
  rtsp://admin:admin123456@<KAMERA_IP>:8554/profile101
```

### **SSH/Telnet:**
```bash
# SSH
ssh root@<KAMERA_IP>
Password: root

# Telnet
telnet <KAMERA_IP>
Login: root
Password: root
```

---

## 🏠 Home Assistant Integration

### **Via ONVIF (Empfohlen):**

```yaml
# configuration.yaml
camera:
  - platform: onvif
    name: QianNiao Kamera
    host: 192.168.1.203
    port: 6688
    username: admin
    password: admin123456
```

### **Via RTSP:**

```yaml
camera:
  - platform: ffmpeg
    name: QianNiao Kamera
    input: rtsp://admin:admin123456@192.168.1.203:8554/profile1
```

### **In UI:**

1. Einstellungen → Geräte & Dienste
2. Integration hinzufügen → ONVIF
3. Host: `192.168.1.203`
4. Port: `6688`
5. User: `admin`
6. Pass: `admin123456`

---

## 🛡️ Backup & Recovery

### **Automatisches Backup:**

Beide Scripts erstellen automatisch ein Backup:

```
Speicherort: /tmp/backup_YYYYMMDD_HHMMSS/
Datei: mtd6_original.img

Zusätzlich auf SD (falls vorhanden):
/mnt/sd/backup_YYYYMMDD_HHMMSS/
```

### **Wiederherstellung:**

```bash
# SSH zur Kamera
ssh root@192.168.1.203

# Backup finden
ls /tmp/backup_*/

# Wiederherstellen
dd if=/tmp/backup_XXXXXXXX/mtd6_original.img of=/dev/mtd6

# Neustart
reboot
```

---

## 🔧 DevKey berechnen (Optional)

**Nur nötig wenn du die laufende ipc.db modifizieren willst!**

```bash
# DevKey von MAC berechnen
python3 devkey_calculator.py AA:BB:CC:DD:EE:FF

# Output:
# DevKey: xRAmbdBG
```

**Hinweis:** Die vorgefertigte Firmware nutzt bereits die gepatchte Default-Config, DevKey wird nur für Live-Modifikationen gebraucht!

---

## ⚠️ Wichtige Hinweise

### **Nach dem Unlock:**

❌ **Cloud:** Komplett geblockt  
❌ **V360 App:** Funktioniert nicht mehr  
❌ **Auto-Updates:** Deaktiviert  

✅ **ONVIF:** Voll funktional  
✅ **RTSP:** Alle Streams verfügbar  
✅ **SSH/Telnet:** Root-Zugriff  
✅ **Home Assistant:** Kompatibel  
✅ **NVR Software:** Kompatibel  

### **Kompatibilität:**

✅ QianNiao QN-L73PV18A0  
⚠️ Andere QianNiao Modelle: Wahrscheinlich  
❌ Andere Marken: Nein  

---

## 📝 Vergleich der Methoden

| Feature | Methode 1 (Flash) | Methode 2 (Build) |
|---------|------------------|-------------------|
| Geschwindigkeit | ⚡ 5 Min | ⏱️ 10 Min |
| Schwierigkeit | ⭐ Einfach | ⭐⭐ Mittel |
| Backup | ✅ Auto | ✅ Auto |
| Anpassbar | ❌ Nein | ✅ Ja |
| DevKey zeigen | ❌ Nein | ✅ Ja |
| System-Info | ❌ Nein | ✅ Ja |
| Für Anfänger | ✅ Perfekt | ⚠️ OK |
| Für Advanced | ⚠️ OK | ✅ Perfekt |

**Empfehlung:**
- **Anfänger:** Methode 1 (flash_firmware.sh)
- **Advanced:** Methode 2 (qianniao_unlock_final.sh)

---

## 🆘 Troubleshooting

### **Problem 1: "Firmware-Image nicht gefunden"**

**Lösung:**
```bash
# Stelle sicher dass ultimate_mtd6.img im gleichen Verzeichnis liegt
ls -l ultimate_mtd6.img

# Oder kopiere es nach /tmp/
cp ultimate_mtd6.img /tmp/

# Oder auf SD-Karte
cp ultimate_mtd6.img /mnt/sd/
```

### **Problem 2: "MTD6 nicht gefunden"**

**Lösung:**
- Prüfe ob du auf der richtigen Kamera bist
- Check: `ls -l /dev/mtd*`
- Wenn leer: Falsches Model oder kein MTD-Support

### **Problem 3: "Flash fehlgeschlagen"**

**Lösung:**
```bash
# Prüfe freien Speicher
df -h

# Lösche temporäre Dateien
rm -rf /tmp/*

# Versuche erneut
./flash_firmware.sh
```

### **Problem 4: Kamera bootet nach Flash nicht**

**Lösung:**
```bash
# Warte 5 Minuten
# Dann: Backup wiederherstellen

dd if=/tmp/backup_XXXXXXXX/mtd6_original.img of=/dev/mtd6
reboot
```

---

## 📊 Dateigrößen

```
ultimate_mtd6.img             5.4 MB  (Firmware Image)
qianniao_unlock_final.sh       23 KB  (Unlock Script)
flash_firmware.sh             7.4 KB  (Flash Script)
devkey_calculator.py           13 KB  (DevKey Tool)
ANLEITUNG_FÜR_DUMMIES.md       15 KB  (Anleitung)

Gesamtpaket komprimiert:      5.5 MB
```

---

## 📞 Support & Info

### **Website:**
https://datenretter-pro.de

### **Blog-Posts:**
- Teil 1: https://datenretter-pro.de/2025/04/20/qianniao-kamera/
- Teil 2: https://datenretter-pro.de/2025/07/14/qianniao-kamera-part-ii/
- Unlock Guide: https://datenretter-pro.de/qianniao-unlock

### **Download:**
https://datenretter-pro.de/qianniao-firmware

---

## ⚖️ Lizenz

**MIT License**

Copyright © 2025 datenretter-pro.de

Verwendung auf eigene Gefahr.  
Keine Garantie oder Gewährleistung.  
Backup wird empfohlen.

---

## ✅ Checkliste

Vor dem Flash:
- [ ] Kamera-IP notiert
- [ ] Dateien kopiert
- [ ] SSH funktioniert
- [ ] Richtiges Model (QN-L73PV18A0)

Nach dem Flash:
- [ ] Kamera neu gestartet
- [ ] ONVIF getestet (Browser)
- [ ] RTSP getestet (VLC)
- [ ] SSH getestet
- [ ] Home Assistant konfiguriert

**Alles gecheckt? Dann los! 🚀**

---

**Copyright © 2025 datenretter-pro.de**  
**Version: 3.0 FINAL**  
**Your camera. Your rules. No cloud. No bullshit.** 🔓
